<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Order extends Model 
{

    protected $table = 'orders';
    public $timestamps = true;
    protected $fillable = array('start_address_id', 'end_address_id', 'pay_advance', 'schedule_date', 'is_published', 'orderable_type', 'orderable_id');

    public function products()
    {
        return $this->belongsToMany('App\Models\Product');
    }

    public function deliveries()
    {
        return $this->belongsToMany('App\Models\Delivery');
    }

    public function delivery()
    {
        return $this->belongsTo('App\Models\Delivery');
    }

    public function deliveryCommission()
    {
        return $this->hasOne('App\Models\ApplicationCommission');
    }

    public function reviews()
    {
        return $this->hasMany('App\Models\Review');
    }

    public function startAddress()
    {
        return $this->belongsTo('App\Models\Address', 'start_address_id');
    }

    public function endAddress()
    {
        return $this->belongsTo('App\Models\Address', 'end_address_id');
    }

    public function orderable()
    {
        return $this->morphTo();
    }

}